<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoPrgSuministros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_prg_suministros', function (Blueprint $table) {
            $table->bigIncrements('cps_pk_id');

            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cps_ano');
            $table->integer('cps_mes');

            $table->integer('prg_fk_id');
            $table->integer('coe_fk_id');
            $table->integer('sed_fk_id');
            $table->integer('esp_fk_id');

            $table->integer('sum_fk_id');

            $table->float('cps_costo_suministro')->nullable();

            $table->index(['con_fk_id', 'ins_fk_id', 'cps_ano', 'cps_mes', 'prg_fk_id', 'sum_fk_id'], 'c_prg_s_index1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_prg_suministros');
    }
}
