<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Programas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('programas', function (Blueprint $table) {
            $table->bigIncrements('prg_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('prg_ano');
            $table->string('prg_codigo', 30);
            $table->string('prg_descripcion', 500);
            $table->integer('coe_fk_id');
            $table->string('prg_unidad_medicion_pago', 500);
            $table->string('prg_desc_estadios', 2000);
            $table->string('prg_id_sedes', 500);
            $table->boolean('prg_asignado')->default(false);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('coe_fk_id')->references('coe_pk_id')->on('contratos_eps')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'prg_ano'], 'prg_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'prg_ano', 'prg_codigo'], 'prg_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'prg_ano', 'prg_codigo', 'coe_fk_id'], 'prg_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'coe_fk_id'], 'prg_index4');
            $table->index(['coe_fk_id'], 'prg_index5');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('programas');
    }
}
