<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class PaquetesActividades extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('paquetes_actividades', function (Blueprint $table) {
            $table->bigIncrements('paq_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('paq_ano');
            $table->integer('paq_paquete');
            $table->integer('cco_fk_id');
            $table->integer('paq_actividad')->nullable();
            $table->integer('paq_suministro')->nullable();
            $table->integer('paq_frec_realizacion');
            $table->integer('paq_cantidad');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('paq_paquete')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('paq_actividad')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('paq_suministro')->references('sum_pk_id')->on('suministros')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'paq_ano'], 'paq_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'paq_ano', 'paq_paquete'], 'paq_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'paq_ano', 'paq_paquete', 'cco_fk_id'], 'paq_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'paq_ano', 'paq_paquete', 'cco_fk_id', 'paq_actividad'], 'paq_index4');
            $table->index(['con_fk_id', 'ins_fk_id', 'paq_ano', 'paq_paquete', 'cco_fk_id', 'paq_suministro'], 'paq_index5');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('paquetes_actividades');
    }
}
