<?php

namespace App\Http\Controllers;

use App\Models\Instituciones;
use App\Models\InstitucionesReps;
use App\Models\Sedes;
use App\Models\SedesReps;
use Illuminate\Http\Request;

class InstitucionesRepsController extends Controller
{
    public function crearInstitucion(Request $request) {
        $codHabilitacion = $request->input('codHabilitacion');
        $nit = $request->input('nit');
        $razonSocial = $request->input('razonSocial');
        $repLegal = $request->input('repLegal');
        $departamento = $request->input('departamento');
        $municipio = $request->input('municipio');
        $direccion = $request->input('direccion');

        $registro = InstitucionesReps::on('costos_principal');

        $id = $registro->create(
            [
                "inr_pk_id" => $codHabilitacion,
                "inr_nit" => $nit,
                "inr_razon_social" => $razonSocial,
                "inr_rep_legal" => $repLegal,
                "dep_fk_id" => $departamento,
                "mun_fk_id" => $municipio,
                "inr_direccion" => $direccion
            ]
        );

        return array("response" => $id->inr_pk_id);
    }

    public function getInstituciones(Request $request) {
        $depto = $request->input('depto');
        $municipio = $request->input('municipio');

        return json_encode(InstitucionesReps::on('costos_principal')
                                            ->join('departamentos', 'instituciones_reps.dep_fk_id', '=', 'dep_pk_id')
                                            ->join('municipios', 'mun_fk_id', '=', 'mun_pk_id')
                                            ->where('instituciones_reps.dep_fk_id', $depto)
                                            ->where('mun_fk_id', $municipio)
                                            ->orderBy('inr_razon_social', 'asc')
                                            ->get());
    }

    public function getInstContrato(Request $request) {
        $contrato = $request->input('contrato');

        return json_encode(Instituciones::on('costos_principal')
                                        ->join('departamentos', 'dep_fk_id', '=', 'dep_pk_id')
                                        ->join('municipios', 'mun_fk_id', '=', 'mun_pk_id')
                                        ->where('con_fk_id', $contrato)->get());
    }

    public function getInstPorCodigo(Request $request) {
        return json_encode(InstitucionesReps::on('costos_principal')
                                            ->where('inr_pk_id', $request->input('codigo'))->get());
    }

    public function setInstContrato(Request $request) {
        $contrato = $request->input('contrato');
        $instituciones = $request->input('instituciones');

        foreach($instituciones as $ins) {
            $nuevaInstitucion = Instituciones::on('costos_principal');

            $nuevaInstitucion->insert(
                [
                    "ins_pk_id" => $ins['ins_pk_id'],
                    "con_fk_id" => $contrato,
                    "ins_nit" => $ins['ins_nit'],
                    "ins_razon_social" => $ins['ins_razon_social'],
                    "ins_rep_legal" => $ins['ins_rep_legal'],
                    "dep_fk_id" => $ins['dep_fk_id'],
                    "mun_fk_id" => $ins['mun_fk_id'],
                    "ins_direccion" => $ins['ins_direccion']
                ]
            );
        }

        return array("response" => 1);
    }

    public function setSedesContrato(Request $request) {
        $contrato = $request->input('contrato');
        $sedes = json_decode($request->input('sedes'));

        foreach($sedes as $sede) {
            $nuevaSede = Sedes::on('costos_principal');

            $nuevaSede->insert(
                [
                    'sed_pk_id' => $sede->ser_pk_id,
                    'con_fk_id' => $contrato,
                    'ins_fk_id' => $sede->inr_fk_id,
                    'sed_nombre_sede' => $sede->ser_nombre_sede,
                    'sed_direccion' => $sede->ser_direccion
                ]
            );
        }
    }

    public function actualizarInstitucionReps(Request $request) {
        $codHabilitacion = $request->input('codHabilitacion');
        $nit = $request->input('nit');
        $razonSocial = $request->input('razonSocial');
        $repLegal = $request->input('repLegal');
        $departamento = $request->input('departamento');
        $municipio = $request->input('municipio');
        $direccion = $request->input('direccion');

        InstitucionesReps::on('costos_principal')
                        ->where('inr_pk_id', $codHabilitacion)
                        ->update(
                        [
                            "inr_nit" => $nit,
                            "inr_razon_social" => $razonSocial,
                            "inr_rep_legal" => $repLegal,
                            "dep_fk_id" => $departamento,
                            "mun_fk_id" => $municipio,
                            "inr_direccion" => $direccion
                        ]
                        );

        return array("response" => 0);
    }
}
