<?php

namespace App\Http\Controllers;

use App\Models\Costos;
use Illuminate\Http\Request;

class DetalleCostoPrimarioController extends Controller
{
    public function getDetalleCostoPrimarioManoObra(Request $request) {
        $contrato = $request->input('con_fk_id');
        $institucion = $request->input('ins_fk_id');
        $ano = $request->input('rcc_ano');
        $mes = $request->input('rcc_mes');

        return \DB::select("
            select cco.scu_codigo,
                   cco.scu_descripcion,
                   cco.cco_cod_homologado,
                   cco.cco_descripcion,
                   mob.mob_codigo,
                   mob.mob_cargo,
                   imo.mot_nit_tercero,
                   imo.mot_razon_social,
                   imo.imo_valor,
                   imo.imo_horas
            from (
                select cco_fk_id,
                       imo.mob_fk_id,
                       mot.mot_nit_tercero,
                       mot.mot_razon_social,
                       imo_horas,
                       coalesce(imo_valor * imo_horas / nullif((
                            select sum(imo_horas)
                            from costos_principal.informacion_mano_obra
                            where imo.con_fk_id = ".$contrato." and
                                  imo.ins_fk_id = '".$institucion."' and
                                  imo_ano = ".$ano." and
                                  imo_mes = ".$mes." and
                                  mob_fk_id = imo.mob_fk_id and
                                  mot_fk_id in (
                                      select mot_pk_id
                                      from costos_principal.mano_obra_terceros
                                      where con_fk_id = ".$contrato." and
                                            ins_fk_id = '".$institucion."' and
                                            mot_ano = ".$ano." and
                                            mot_mes = ".$mes." and
                                            mot_nit_tercero = mot.mot_nit_tercero
                                )
                        ), 0), 0) as imo_valor
                from costos_principal.informacion_mano_obra as imo
                join costos_principal.mano_obra_terceros as mot on (imo.mot_fk_id = mot.mot_pk_id)
                where imo.con_fk_id = ".$contrato." and
                      imo.ins_fk_id = '".$institucion."' and
                      imo_ano = ".$ano." and
                      imo_mes = ".$mes."
            ) as imo
            join costos_principal.mano_obra as mob on (imo.mob_fk_id = mob.mob_pk_id)
            join (
                select cco_pk_id,
                       scu_codigo,
                       scu_descripcion,
                       cco_cod_homologado,
                       cco_descripcion
                from costos_principal.centros_costo as cco
                join costos_principal.subcentros_utilidad as scu on (cco.scu_fk_id = scu.scu_pk_id)
                where cco.con_fk_id = ".$contrato." and
                      cco.ins_fk_id = '".$institucion."' and
                      cco_ano = ".$ano."
                order by 1,3
            ) as cco on (imo.cco_fk_id = cco.cco_pk_id)
            union all
            select scu.scu_codigo,
                   scu.scu_descripcion,
                   cco.cco_cod_homologado,
                   cco.cco_descripcion,
                   '' as mob_codigo,
                   '' as mob_cargo,
                   '' as mot_nit_tercero,
                   '' as mot_razon_social,
                   rcc.rcc_valor as imo_valor,
                  null as imo_horas
            from (
                select cco_fk_id, sum(rcc_valor) as rcc_valor
                from costos_principal.recursos_centro_costo_mob as rcc
                where con_fk_id = ".$contrato." and ins_fk_id = '".$institucion."' and rcc_ano = ".$ano." and rcc_mes = ".$mes."
                group by 1
            ) as rcc
            join costos_principal.centros_costo as cco on (rcc.cco_fk_id = cco.cco_pk_id)
            join costos_principal.subcentros_utilidad as scu on (cco.scu_fk_id = scu.scu_pk_id)
        ");
    }

    public function getDetalleCostoPrimarioSuministros(Request $request) {
        $contrato = $request->input('con_fk_id');
        $institucion = $request->input('ins_fk_id');
        $ano = $request->input('rcc_ano');
        $mes = $request->input('rcc_mes');

        return \DB::select("
            select cco_cod_homologado, cco_descripcion, del_descripcion, sum(rcc_valor) as rcc_valor
            from costos_principal.recursos_centro_costo as rcc
            join costos_principal.centros_costo as cco on (rcc.cco_fk_id =  cco.cco_pk_id)
            join costos_principal.cuentas_contables as cuc on (rcc.cuc_fk_id = cuc.cuc_pk_id)
            join costos_principal.detalle_elementos as del on (cuc.del_fk_id = del.del_pk_id)
            where rcc.con_fk_id = ".$contrato." and
                  rcc.ins_fk_id = '".$institucion."' and
                  rcc_ano = ".$ano." and
                  rcc_mes = ".$mes." and
                  cuc.elm_fk_id = 4
            group by 1,2,3
            order by 1
        ");
    }

    public function getDetalleCostoPrimarioGastos(Request $request) {
        $contrato = $request->input('con_fk_id');
        $institucion = $request->input('ins_fk_id');
        $ano = $request->input('rcc_ano');
        $mes = $request->input('rcc_mes');

        return \DB::select("
            select cco_cod_homologado, cco_descripcion, del_descripcion, sum(rcc_valor) as rcc_valor
            from costos_principal.recursos_centro_costo as rcc
            join costos_principal.centros_costo as cco on (rcc.cco_fk_id =  cco.cco_pk_id)
            join costos_principal.cuentas_contables as cuc on (rcc.cuc_fk_id = cuc.cuc_pk_id)
            join costos_principal.detalle_elementos as del on (cuc.del_fk_id = del.del_pk_id)
            where rcc.con_fk_id = ".$contrato." and
                  rcc.ins_fk_id = '".$institucion."' and
                  rcc_ano = ".$ano." and
                  rcc_mes = ".$mes." and
                  cuc.elm_fk_id = 2
            group by 1,2,3
            order by 1
        ");
    }
}
