<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoUnitario extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_unitario', function (Blueprint $table) {
            $table->increments('cun_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cun_ano');
            $table->integer('cun_mes');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->float('cun_mob_directa')->nullable();
            $table->float('cun_mob_indirecta')->nullable();
            $table->float('cun_sum_directo')->nullable();
            $table->float('cun_sum_indirecto')->nullable();
            $table->float('cun_gastos_gen')->nullable();
            $table->float('cun_costo_dist')->nullable();
            $table->float('cun_costo_unitario')->nullable();
            $table->boolean('cun_extrapolado')->default(false);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'cun_ano', 'cun_mes'], 'cun_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'cun_ano', 'cun_mes', 'cco_fk_id'], 'cun_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'cun_ano', 'cun_mes', 'cco_fk_id', 'act_fk_id'], 'cun_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_unitario');
    }
}
