<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InformacionManoObra extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('informacion_mano_obra', function (Blueprint $table) {
            $table->increments('imo_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('imo_ano');
            $table->integer('imo_mes');
            $table->integer('mot_fk_id');
            $table->integer('mob_fk_id');
            $table->integer('cco_fk_id');
            $table->float('imo_horas');
            $table->float('imo_valor')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('mot_fk_id')->references('mot_pk_id')->on('mano_obra_terceros')->onDelete('cascade');
            $table->foreign('mob_fk_id')->references('mob_pk_id')->on('mano_obra')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'imo_ano', 'imo_mes'], 'imo_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'imo_ano', 'imo_mes', 'mot_fk_id'], 'imo_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'imo_ano', 'imo_mes', 'mot_fk_id', 'mob_fk_id', 'cco_fk_id'], 'imo_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('informacion_mano_obra');
    }
}
