<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoPrimario extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_primario', function (Blueprint $table) {
            $table->increments('cpr_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cpr_ano');
            $table->integer('cpr_mes');
            $table->integer('cco_fk_id');
            $table->float('cpr_suministros_directos');
            $table->float('cpr_suministros_indirectos');
            $table->float('cpr_suministros_fijos');
            $table->float('cpr_suministros_variables');
            $table->float('cpr_suministros_total');
            $table->float('cpr_mano_obra_directa');
            $table->float('cpr_mano_obra_indirecta');
            $table->float('cpr_mano_obra_fija');
            $table->float('cpr_mano_obra_variable');
            $table->float('cpr_mano_obra_total');
            $table->float('cpr_gastos_gen_directos');
            $table->float('cpr_gastos_gen_indirectos');
            $table->float('cpr_gastos_gen_fijos');
            $table->float('cpr_gastos_gen_variables');
            $table->float('cpr_gastos_gen_total');
            $table->float('cpr_costos_directos');
            $table->float('cpr_costos_indirectos');
            $table->float('cpr_costos_fijos');
            $table->float('cpr_costos_variables');
            $table->float('cpr_total');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'cpr_ano', 'cpr_mes', 'cco_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'cpr_ano', 'cpr_mes']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cpr_ano', 'cpr_mes', 'cco_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costos_primario');
    }
}
