<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InformacionBasesDistribucion extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('informacion_bases_distribucion', function (Blueprint $table) {
            $table->increments('ibd_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('ibd_ano');
            $table->integer('ibd_mes');
            $table->integer('cco_fk_id');
            $table->integer('bdi_fk_id');
            $table->float('ibd_valor');
            $table->boolean('ibd_automatico')->default(false);
            $table->boolean('ibd_costo_primario')->default(false);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('bdi_fk_id')->references('bdi_pk_id')->on('bases_distribucion')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'ibd_ano', 'ibd_mes'], 'ibd_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'ibd_ano', 'ibd_mes', 'cco_fk_id'], 'ibd_index2');

            $table->unique(['con_fk_id', 'ins_fk_id', 'ibd_ano', 'ibd_mes', 'cco_fk_id', 'bdi_fk_id', 'ibd_costo_primario']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('informacion_bases_distribucion');
    }
}
