<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ManoObraCentroCosto extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mano_obra_centro_costo', function (Blueprint $table) {
            $table->bigIncrements('mcc_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('mcc_ano');
            $table->integer('cco_fk_id');
            $table->integer('mob_fk_id');
            $table->integer('tre_fk_id');
            $table->integer('cre_fk_id');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('mob_fk_id')->references('mob_pk_id')->on('mano_obra')->onDelete('cascade');
            $table->foreign('tre_fk_id')->references('tre_pk_id')->on('tipo_recurso')->onDelete('cascade');
            $table->foreign('cre_fk_id')->references('cre_pk_id')->on('caracter_recurso')->onDelete('cascade');

            // Consultas
            $table->index(['con_fk_id', 'ins_fk_id', 'mcc_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'mcc_ano', 'cco_fk_id']);
            $table->index(['con_fk_id', 'ins_fk_id', 'mcc_ano', 'cco_fk_id', 'mob_fk_id']);

            // Foraneas
            $table->index(['cco_fk_id']);
            $table->index(['mob_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mano_obra_centro_costo');
    }
}
