<?php

namespace App\Http\Controllers;

use App\Models\Programas;
use App\Models\SedesProgramas;
use App\Models\EstadiosProgramas;
use App\Models\ActividadesProgramas;
use App\Models\SuministrosProgramas;
use App\Models\PaquetesProgramas;
use App\Models\Sedes;
use App\Models\Actividades;
use App\Models\CentrosCosto;
use App\Models\ActividadesCentroCosto;
use App\Models\Suministros;
use Illuminate\Http\Request;

class GestionProgramasController extends Controller
{
  private $apiKey;

  function __construct() {
    $apiController = new ApiController();

    $this->apiKey = $apiController->getApiKey()["key"];
  }

  public function obtenerAvanceProgramas(Request $request) {
    $contrato = $request->input('con_fk_id');
    $institucion = $request->input('ins_fk_id');
    $ano = $request->input('prg_ano');

    return \DB::select("
      select prg.prg_pk_id,
           sep.sep_pk_id,
           esp.esp_pk_id,
           coalesce(acp.actividades, 0) as actividades,
           coalesce(sup.suministros, 0) as suministros,
           coalesce(pap.paquetes, 0) as paquetes
      from costos_principal.programas as prg
      join costos_principal.sedes_programas as sep on (sep.prg_fk_id = prg.prg_pk_id)
      join costos_principal.estadios_programas as esp on (esp.prg_fk_id = prg.prg_pk_id)
      left join (
        select prg_fk_id, sep_fk_id, esp_fk_id, count(*) as actividades
        from costos_principal.actividades_programas
        where con_fk_id = ".$contrato." and ins_fk_id = '".$institucion."' and acp_ano = ".$ano."
        group by 1,2,3
      ) acp on (acp.prg_fk_id = prg.prg_pk_id and acp.sep_fk_id = sep.sep_pk_id and acp.esp_fk_id = esp.esp_pk_id)
      left join (
        select prg_fk_id, sep_fk_id, esp_fk_id, count(*) as suministros
        from costos_principal.suministros_programas
        where con_fk_id = ".$contrato." and ins_fk_id = '".$institucion."' and sup_ano = ".$ano."
        group by 1,2,3
      ) sup on (sup.prg_fk_id = prg.prg_pk_id and sup.sep_fk_id = sep.sep_pk_id and acp.esp_fk_id = esp.esp_pk_id)
      left join (
        select prg_fk_id, sep_fk_id, esp_fk_id, count(*) as paquetes
        from costos_principal.paquetes_programas
        where con_fk_id = ".$contrato." and ins_fk_id = '".$institucion."' and pap_ano = ".$ano."
        group by 1,2,3
      ) pap on (pap.prg_fk_id = prg.prg_pk_id and pap.sep_fk_id = sep.sep_pk_id and pap.esp_fk_id = esp.esp_pk_id)
      where prg.con_fk_id = ".$contrato." and prg.ins_fk_id = '".$institucion."' and prg_ano = ".$ano."
      order by 1,2,3
    ");
  }

  public function obtenerAsignacionActividades(Request $request) {
    return ActividadesProgramas::on('costos_principal')
                   ->selectRaw('actividades_programas.*, act_codigo, act_descripcion')
                   ->join('actividades', 'act_fk_id', 'act_pk_id')
                   ->where('actividades_programas.con_fk_id', $request->input('con_fk_id'))
                   ->where('actividades_programas.ins_fk_id', $request->input('ins_fk_id'))
                   ->where('prg_fk_id', $request->input('prg_fk_id'))
                   ->where('sep_fk_id', $request->input('sep_fk_id'))
                   ->where('esp_fk_id', $request->input('esp_fk_id'))
                   ->get()->toArray();
  }

  public function obtenerAsignacionSuministros(Request $request) {
    return SuministrosProgramas::on('costos_principal')
                   ->selectRaw('suministros_programas.*, sum_codigo, sum_nombre')
                   ->join('suministros', 'sum_fk_id', 'sum_pk_id')
                   ->where('suministros_programas.con_fk_id', $request->input('con_fk_id'))
                   ->where('suministros_programas.ins_fk_id', $request->input('ins_fk_id'))
                   ->where('prg_fk_id', $request->input('prg_fk_id'))
                   ->where('sep_fk_id', $request->input('sep_fk_id'))
                   ->where('esp_fk_id', $request->input('esp_fk_id'))
                   ->get()->toArray();
  }
  public function obtenerAsignacionPaquetes(Request $request) {
    return PaquetesProgramas::on('costos_principal')
                ->where('con_fk_id', $request->input('con_fk_id'))
                ->where('ins_fk_id', $request->input('ins_fk_id'))
                ->where('prg_fk_id', $request->input('prg_fk_id'))
                ->where('sep_fk_id', $request->input('sep_fk_id'))
                ->where('esp_fk_id', $request->input('esp_fk_id'))
                ->get()->toArray();
  }

  public function crearAsignacionProgramas(Request $request) {
    \DB::transaction(function () use($request) {
      $actividades = $request->input('actividades');
      $suministros = $request->input('suministros');
      $paquetes = $request->input('paquetes');

      // Actividades
      foreach($actividades as $acp) {
        ActividadesProgramas::on('costos_principal')->create(
          [
            'con_fk_id' => $request->input('con_fk_id'),
            'ins_fk_id' => $request->input('ins_fk_id'),
            'acp_ano' => $request->input('prg_ano'),
            'prg_fk_id' => $request->input('prg_fk_id'),
            'sep_fk_id' => $request->input('sep_fk_id'),
            'esp_fk_id' => $request->input('esp_fk_id'),
            'cco_fk_id' => $acp['cco_fk_id'],
            'act_fk_id' => $acp['act_fk_id'],
            'acp_cantidad' => $acp['acp_cantidad'],
            'acp_periodicidad' => $acp['acp_cantidad']
          ]
        );
      }

      // Suministros
      foreach($suministros as $sup) {
        SuministrosProgramas::on('costos_principal')->create(
          [
            'con_fk_id' => $request->input('con_fk_id'),
            'ins_fk_id' => $request->input('ins_fk_id'),
            'sup_ano' => $request->input('prg_ano'),
            'prg_fk_id' => $request->input('prg_fk_id'),
            'sep_fk_id' => $request->input('sep_fk_id'),
            'esp_fk_id' => $request->input('esp_fk_id'),
            'grs_fk_id' => $sup['grs_fk_id'],
            'sum_fk_id' => $sup['sum_fk_id'],
            'sup_cantidad' => $sup['sup_cantidad'],
            'sup_periodicidad' => $sup['sup_periodicidad']
          ]
        );
      }

      // Paquetes
      foreach($paquetes as $pap) {
        PaquetesProgramas::on('costos_principal')->create(
          [
            'con_fk_id' => $request->input('con_fk_id'),
            'ins_fk_id' => $request->input('ins_fk_id'),
            'pap_ano' => $request->input('prg_ano'),
            'prg_fk_id' => $request->input('prg_fk_id'),
            'sep_fk_id' => $request->input('sep_fk_id'),
            'esp_fk_id' => $request->input('esp_fk_id'),
            'act_fk_id' => $pap['act_fk_id'],
            'pap_cantidad' => $pap['pap_cantidad'],
            'pap_periodicidad' => $pap['pap_periodicidad']
          ]
        );
      }
    });

    return array("response" => 0);
  }

  public function actualizarAsignacionProgramas(Request $request) {
    \DB::transaction(function () use($request) {
      $actividades = $request->input('actividades');
      $suministros = $request->input('suministros');
      $paquetes = $request->input('paquetes');

      // Borrar la información anterior
      ActividadesProgramas::on('costos_principal')
                ->where('con_fk_id', $request->input('con_fk_id'))
                ->where('ins_fk_id', $request->input('ins_fk_id'))
                ->where('acp_ano', $request->input('prg_ano'))
                ->where('prg_fk_id', $request->input('prg_fk_id'))
                ->where('sep_fk_id', $request->input('sep_fk_id'))
                ->where('esp_fk_id', $request->input('esp_fk_id'))
                ->delete();

      SuministrosProgramas::on('costos_principal')
                ->where('con_fk_id', $request->input('con_fk_id'))
                ->where('ins_fk_id', $request->input('ins_fk_id'))
                ->where('sup_ano', $request->input('prg_ano'))
                ->where('prg_fk_id', $request->input('prg_fk_id'))
                ->where('sep_fk_id', $request->input('sep_fk_id'))
                ->where('esp_fk_id', $request->input('esp_fk_id'))
                ->delete();

      PaquetesProgramas::on('costos_principal')
                ->where('con_fk_id', $request->input('con_fk_id'))
                ->where('ins_fk_id', $request->input('ins_fk_id'))
                ->where('pap_ano', $request->input('prg_ano'))
                ->where('prg_fk_id', $request->input('prg_fk_id'))
                ->where('sep_fk_id', $request->input('sep_fk_id'))
                ->where('esp_fk_id', $request->input('esp_fk_id'))
                ->delete();

      // Actividades
      foreach($actividades as $acp) {
        ActividadesProgramas::on('costos_principal')->create(
          [
            'con_fk_id' => $request->input('con_fk_id'),
            'ins_fk_id' => $request->input('ins_fk_id'),
            'acp_ano' => $request->input('prg_ano'),
            'prg_fk_id' => $request->input('prg_fk_id'),
            'sep_fk_id' => $request->input('sep_fk_id'),
            'esp_fk_id' => $request->input('esp_fk_id'),
            'cco_fk_id' => $acp['cco_fk_id'],
            'act_fk_id' => $acp['act_fk_id'],
            'acp_cantidad' => $acp['acp_cantidad'],
            'acp_periodicidad' => $acp['acp_periodicidad']
          ]
        );
      }

      // Suministros
      foreach($suministros as $sup) {
        SuministrosProgramas::on('costos_principal')->create(
          [
            'con_fk_id' => $request->input('con_fk_id'),
            'ins_fk_id' => $request->input('ins_fk_id'),
            'sup_ano' => $request->input('prg_ano'),
            'prg_fk_id' => $request->input('prg_fk_id'),
            'sep_fk_id' => $request->input('sep_fk_id'),
            'esp_fk_id' => $request->input('esp_fk_id'),
            'grs_fk_id' => $sup['grs_fk_id'],
            'sum_fk_id' => $sup['sum_fk_id'],
            'sup_cantidad' => $sup['sup_cantidad'],
            'sup_periodicidad' => $sup['sup_periodicidad']
          ]
        );
      }

      // Paquetes
      foreach($paquetes as $pap) {
        PaquetesProgramas::on('costos_principal')->create(
          [
            'con_fk_id' => $request->input('con_fk_id'),
            'ins_fk_id' => $request->input('ins_fk_id'),
            'pap_ano' => $request->input('prg_ano'),
            'prg_fk_id' => $request->input('prg_fk_id'),
            'sep_fk_id' => $request->input('sep_fk_id'),
            'esp_fk_id' => $request->input('esp_fk_id'),
            'act_fk_id' => $pap['act_fk_id'],
            'pap_cantidad' => $pap['pap_cantidad'],
            'pap_periodicidad' => $pap['pap_periodicidad']
          ]
        );
      }
    });

    return array("response" => 1);
  }

  public function cargarArchivoGestionPaquetes(Request $request) {
    $apiKey = $request->apiKey;

    if ($apiKey === $this->apiKey) {
      $rutaDelArchivo = $request->gestionProgramas->path();
      $delimitador = $request->delimitador;
      $archivo = fopen($rutaDelArchivo, 'r');
      $gestionProgramas = array();
      $primeraLinea = true;

      // Extraer cada línea del archivo CSV y convertirlo en un arreglo
      while($linea = fgetcsv($archivo, 1000, $delimitador)) {
        if (!$primeraLinea) {
          $registro = $linea;
          array_push($gestionProgramas, $registro);
        } else {
          $primeraLinea = false;
        }
      }

      fclose($archivo);

      return $this->procesarArchivoGestionProgramas($gestionProgramas,
                              $request->con_fk_id,
                              $request->ins_fk_id,
                              $request->prg_ano);
    } else {
      throw new \Exception('Imposible completar la petición.');
    }
  }

  private function procesarArchivoGestionProgramas($gestionProgramas, $con_fk_id, $ins_fk_id, $prg_ano) {
    $resultados = new \stdClass();
    $resultados->errores = "";

    \DB::transaction(function() use(&$resultados, $gestionProgramas, $con_fk_id, $ins_fk_id, $prg_ano) {
      if (count($gestionProgramas) === 0) {
        $resultados->correcto = false;
        $resultados->errores = 'El archivo está vacío. ';
      } else if (count($gestionProgramas[0]) !== 9) {
        $resultados->correcto = false;
        $resultados->errores = 'La cantidad de columnas no corresponde. ';
      } else {
        // Informacion actual
        $actividadesProgramaBd = ActividadesProgramas::on('costos_principal')
                               ->where('con_fk_id', $con_fk_id)
                               ->where('ins_fk_id', $ins_fk_id)
                               ->where('acp_ano', $prg_ano)
                               ->get()->toArray();

        $suministrosProgramaBd = SuministrosProgramas::on('costos_principal')
                               ->where('con_fk_id', $con_fk_id)
                               ->where('ins_fk_id', $ins_fk_id)
                               ->where('sup_ano', $prg_ano)
                               ->get()->toArray();

        $paquetesProgramaBd = PaquetesProgramas::on('costos_principal')
                             ->where('con_fk_id', $con_fk_id)
                             ->where('ins_fk_id', $ins_fk_id)
                             ->where('pap_ano', $prg_ano)
                             ->get()->toArray();

        // Parametros de la base de datos
        $programasBd = Programas::on('costos_principal')
                    ->where('con_fk_id', $con_fk_id)
                    ->where('ins_fk_id', $ins_fk_id)
                    ->where('prg_ano', $prg_ano)
                    ->get()->toArray();

        $sedesPrgBd = SedesProgramas::on('costos_principal')
                      ->where('con_fk_id', $con_fk_id)
                      ->where('ins_fk_id', $ins_fk_id)
                      ->where('sep_ano', $prg_ano)
                      ->get()->toArray();

        $estadiosBd = EstadiosProgramas::on('costos_principal')
                         ->where('con_fk_id', $con_fk_id)
                         ->where('ins_fk_id', $ins_fk_id)
                         ->where('esp_ano', $prg_ano)
                         ->get()->toArray();

        $actividadesBd = Actividades::on('costos_principal')
                      ->where('con_fk_id', $con_fk_id)
                      ->where('ins_fk_id', $ins_fk_id)
                      ->where('act_ano', $prg_ano)
                      ->where('act_paquete', false)
                      ->get()->toArray();

        $centrosCostoBd = CentrosCosto::on('costos_principal')
                        ->where('con_fk_id', $con_fk_id)
                        ->where('ins_fk_id', $ins_fk_id)
                        ->where('cco_ano', $prg_ano)
                        ->where('cco_final', true)
                        ->get()->toArray();

        $actividadesCcoBd = ActividadesCentroCosto::on('costos_principal')
                              ->where('con_fk_id', $con_fk_id)
                              ->where('ins_fk_id', $ins_fk_id)
                              ->where('acc_ano', $prg_ano)
                              ->get()->toArray();

        $suministrosBd = Suministros::on('costos_principal')
                      ->where('con_fk_id', $con_fk_id)
                      ->where('ins_fk_id', $ins_fk_id)
                      ->where('sum_ano', $prg_ano)
                      ->get()->toArray();

        $paquetesBd = Actividades::on('costos_principal')
                     ->where('con_fk_id', $con_fk_id)
                     ->where('ins_fk_id', $ins_fk_id)
                     ->where('act_ano', $prg_ano)
                     ->where('act_paquete', true)
                     ->get()->toArray();

        // Crear las relaciones existentes en la base de datos
        $programasExistentes = [];
        $sedesExistentes = [];
        $sedesPrgExistentes = [];
        $estadiosExistentes = [];
        $actividadesProgramaExistentes = [];
        $suministrosProgramaExistentes = [];
        $paquetesProgramaExistentes = [];
        $actividadesExistentes = [];
        $centrosCostoExistentes = [];
        $actividadesCcoExistentes = [];
        $suministrosExistentes = [];
        $paquetesExistentes = [];
        $registrosProcesados = 0;

        foreach ($programasBd as $prgDb) {
          $programasExistentes[$prgDb['prg_codigo']][$prgDb['coe_fk_id']] = $prgDb['prg_pk_id'];
        }

        foreach ($sedesPrgBd as $sedDb) {
          $sedesPrgExistentes[$sedDb['prg_fk_id']][$sedDb['sed_fk_id']] = $sedDb['sep_pk_id'];
        }

        foreach ($estadiosBd as $espDb) {
          $estadiosExistentes[$espDb['prg_fk_id']][$espDb['esp_codigo']] = $espDb['esp_pk_id'];
        }

        foreach ($actividadesProgramaBd as $acpDb) {
          $actividadesProgramaExistentes[$acpDb['prg_fk_id']][$acpDb['sep_fk_id']][$acpDb['esp_fk_id']][$acpDb['cco_fk_id']][$acpDb['act_fk_id']] = $acpDb['acp_pk_id'];
        }

        foreach ($suministrosProgramaBd as $supDb) {
          $suministrosProgramaExistentes[$supDb['prg_fk_id']][$supDb['sep_fk_id']][$supDb['esp_fk_id']][$supDb['sum_fk_id']] = $supDb['sup_pk_id'];
        }

        foreach ($paquetesProgramaBd as $papDb) {
          $paquetesProgramaExistentes[$papDb['prg_fk_id']][$papDb['sep_fk_id']][$papDb['esp_fk_id']][$papDb['act_fk_id']] = $papDb['pap_pk_id'];
        }

        foreach ($actividadesBd as $actDb) {
          $actividadesExistentes[$actDb['act_codigo']] = $actDb['act_pk_id'];
        }

        foreach ($centrosCostoBd as $ccoDb) {
          $centrosCostoExistentes[$ccoDb['cco_cod_homologado']] = new \stdClass();
          $centrosCostoExistentes[$ccoDb['cco_cod_homologado']]->cco_pk_id = $ccoDb['cco_pk_id'];
          $centrosCostoExistentes[$ccoDb['cco_cod_homologado']]->sed_fk_id = $ccoDb['sed_fk_id'];
        }

        foreach ($actividadesCcoBd as $accDb) {
          $actividadesCcoExistentes[$accDb['cco_fk_id']][$accDb['act_fk_id']] = $accDb['acc_pk_id'];
        }

        foreach ($suministrosBd as $sumDb) {
          $suministrosExistentes[$sumDb['sum_codigo']] = new \stdClass();
          $suministrosExistentes[$sumDb['sum_codigo']]->sum_pk_id = $sumDb['sum_pk_id'];
          $suministrosExistentes[$sumDb['sum_codigo']]->grs_fk_id = $sumDb['grs_fk_id'];
        }

        foreach ($paquetesBd as $paqDb) {
          $paquetesExistentes[$paqDb['act_codigo']] = $paqDb['act_pk_id'];
        }

        // Errores
        $camposVacios = false;
        $programasInexistentes = "";
        $sedesInexistentes = "";
        $estadiosInexistentes = "";
        $tiposRecursoErroneos = false;
        $centrosCostoInexistentes = "";
        $centrosCostoIncorrectos = "";
        $actividadesInexistentes = "";
        $actividadesCcoInexistentes = "";
        $suministrosInexistentes = "";
        $paquetesInexistentes = "";
        $numerosIncorrectos = false;
        $periodicidadIncorrecta = false;

        // Revisar el archivo respecto a las relaciones existentes
        foreach($gestionProgramas as $gprCsv) {
          $programa = trim($gprCsv[0]);
          $contrato = trim($gprCsv[1]);
          $sede = trim($gprCsv[2]);
          $estadio = trim($gprCsv[3]);
          $tipoRecurso = strtoupper(trim($gprCsv[4]));
          $centroCosto = trim($gprCsv[5]);
          $recurso = trim($gprCsv[6]);
          $cantidad = trim($gprCsv[7]);
          $periodicidad = trim($gprCsv[8]);

          // Campos vacios
          if ($programa != "" && $contrato != "" && $sede != "" && $estadio != "" && $tipoRecurso != "" && $recurso != "" && $cantidad != "" && $periodicidad != "") {
            // Existe el programa
            if (isset($programasExistentes[$programa][$contrato])) {
              $idPrg = $programasExistentes[$programa][$contrato];

              // Existe la sede
              if (isset($sedesPrgExistentes[$idPrg][$sede])) {
                $idSede = $sedesPrgExistentes[$idPrg][$sede];

                // Existe el estadío
                if (isset($estadiosExistentes[$idPrg][$estadio])) {
                  $idEsp = $estadiosExistentes[$idPrg][$estadio];

                  // Existe el recurso
                  if ($tipoRecurso == "A" || $tipoRecurso == "S" || $tipoRecurso == "P") {
                    // Cantidad
                    if (is_numeric($cantidad) && $cantidad > 0) {
                      // Periodicidad
                      if (trim($periodicidad) == "1" || trim($periodicidad) == "2" || trim($periodicidad) == "3" || trim($periodicidad) == "6" || trim($periodicidad) == "12") {
                        // Actividad
                        if ($tipoRecurso == "A") {
                          // Centro de costo vacío
                          if ($centroCosto != "") {
                            // Existe el centro de costo
                            if (isset($centrosCostoExistentes[$centroCosto])) {
                              $idCco = $centrosCostoExistentes[$centroCosto]->cco_pk_id;

                              // El centro de costo es de la sede del programa
                              if (intval($centrosCostoExistentes[$centroCosto]->sed_fk_id) == $sede) {
                                // Existe la actividad
                                if (isset($actividadesExistentes[$recurso])) {
                                  // Existe la relacion CCO-ACT
                                  $idAct = $actividadesExistentes[$recurso];

                                  if (isset($actividadesCcoExistentes[$idCco][$idAct])) {
                                    // Existe el registro
                                    if (!isset($actividadesProgramaExistentes[$idPrg][$idSede][$idEsp][$idCco][$idAct])) {
                                      $id = ActividadesProgramas::on('costos_principal')->create(
                                        [
                                          'con_fk_id' => $con_fk_id,
                                          'ins_fk_id' => $ins_fk_id,
                                          'acp_ano' => $prg_ano,
                                          'prg_fk_id' => $idPrg,
                                          'sep_fk_id' => $idSede,
                                          'esp_fk_id' => $idEsp,
                                          'cco_fk_id' => $idCco,
                                          'act_fk_id' => $idAct,
                                          'acp_cantidad' => $cantidad,
                                          'acp_periodicidad' => $periodicidad
                                        ]
                                      )->acp_pk_id;

                                      $actividadesProgramaExistentes[$idPrg][$idSede][$idEsp][$idCco][$idAct] = $id;
                                    } else {
                                      $id = $actividadesProgramaExistentes[$idPrg][$idSede][$idEsp][$idCco][$idAct];

                                      ActividadesProgramas::on('costos_principal')->where('acp_pk_id', $id)
                                      ->update(['acp_cantidad' => $cantidad, 'acp_periodicidad' => $periodicidad]);
                                    }

                                    $registrosProcesados++;
                                  } else {
                                    $actividadesCcoInexistentes .= $centroCosto.' - '.$recurso.", ";
                                  }
                                } else {
                                  $actividadesInexistentes .= $recurso.", ";
                                }
                              } else {
                                $centrosCostoIncorrectos .= $centroCosto." en programa/sede ".$programa."/".$sede.", ";
                              }
                            } else {
                              $centrosCostoInexistentes .= $centroCosto.", ";
                            }
                          } else {
                            $camposVacios = true;
                          }
                        } else if ($tipoRecurso == "S") {
                          // Existe el suministro
                          if (isset($suministrosExistentes[$recurso])) {
                            $idSum = $suministrosExistentes[$recurso];

                            // Existe el registro
                            if (!isset($suministrosProgramaExistentes[$idPrg][$idSede][$idEsp][$idSum->sum_pk_id])) {
                              $id = SuministrosProgramas::on('costos_principal')->create(
                                [
                                  'con_fk_id' => $con_fk_id,
                                  'ins_fk_id' => $ins_fk_id,
                                  'sup_ano' => $prg_ano,
                                  'prg_fk_id' => $idPrg,
                                  'sep_fk_id' => $idSede,
                                  'esp_fk_id' => $idEsp,
                                  'grs_fk_id' => $idSum->grs_fk_id,
                                  'sum_fk_id' => $idSum->sum_pk_id,
                                  'sup_cantidad' => $cantidad,
                                  'sup_periodicidad' => $periodicidad
                                ]
                              )->sup_pk_id;

                              $suministrosProgramaExistentes[$idPrg][$idSede][$idEsp][$idSum->sum_pk_id] = $id;
                            } else {
                              $id = $suministrosProgramaExistentes[$idPrg][$idSede][$idEsp][$idSum->sum_pk_id];

                              SuministrosProgramas::on('costos_principal')->where('sup_pk_id', $id)
                              ->update(['sup_cantidad' => $cantidad, 'sup_periodicidad' => $periodicidad]);
                            }

                            $registrosProcesados++;
                          } else {
                            $suministrosInexistentes .= $recurso.", ";
                          }
                        } else if ($tipoRecurso == "P") {
                          // Existe el paquete
                          if (isset($paquetesExistentes[$recurso])) {
                            $idPaq = $paquetesExistentes[$recurso];

                            // Existe el registro
                            if (!isset($paquetesProgramaExistentes[$idPrg][$idSede][$idEsp][$idPaq])) {
                              $id = PaquetesProgramas::on('costos_principal')->create(
                                [
                                  'con_fk_id' => $con_fk_id,
                                  'ins_fk_id' => $ins_fk_id,
                                  'pap_ano' => $prg_ano,
                                  'prg_fk_id' => $idPrg,
                                  'sep_fk_id' => $idSede,
                                  'esp_fk_id' => $idEsp,
                                  'act_fk_id' => $idPaq,
                                  'pap_cantidad' => $cantidad,
                                  'pap_periodicidad' => $periodicidad
                                ]
                              )->pap_pk_id;

                              $paquetesProgramaExistentes[$idPrg][$idSede][$idEsp][$idPaq] = $id;
                            } else {
                              $id = $paquetesProgramaExistentes[$idPrg][$idSede][$idEsp][$idPaq];

                              PaquetesProgramas::on('costos_principal')->where('pap_pk_id', $id)
                              ->update(['pap_cantidad' => $cantidad, 'pap_periodicidad' => $periodicidad]);
                            }

                            $registrosProcesados++;
                          } else {
                            $paquetesInexistentes .= $recurso.", ";
                          }
                        }
                      } else {
                        $periodicidadIncorrecta = true;
                      }
                    } else {
                      $numerosIncorrectos = true;
                    }
                  } else {
                    $tiposRecursoErroneos = true;
                  }
                } else {
                  $estadiosInexistentes .= $estadio.' en '.$programa.", ";
                }
              } else {
                $sedesInexistentes .= $sede.' en '.$programa.", ";
              }
            } else {
              $programasInexistentes .= $programa." y contrato ".$contrato.", ";
            }
          } else {
            $camposVacios = true;
          }
        }

        // Campos vacios
        if ($camposVacios) {
          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= "Hay campos vacíos. Si es una actividad, recuerde que debe poner el centro de costo.";
        }

        // Errores de programas
        if ($programasInexistentes !== "") {
          $programasInexistentes[strlen($programasInexistentes) - 1] = " ";
          $programasInexistentes[strlen($programasInexistentes) - 2] = " ";
          $programasInexistentes = "No existen los siguientes programas: ".$programasInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $programasInexistentes;
        }

        // Errores de sedes
        if ($sedesInexistentes !== "") {
          $sedesInexistentes[strlen($sedesInexistentes) - 1] = " ";
          $sedesInexistentes[strlen($sedesInexistentes) - 2] = " ";
          $sedesInexistentes = "No existen las siguientes sedes en el programa: ".$sedesInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $sedesInexistentes;
        }

        // Errores de estadios
        if ($estadiosInexistentes !== "") {
          $estadiosInexistentes[strlen($estadiosInexistentes) - 1] = " ";
          $estadiosInexistentes[strlen($estadiosInexistentes) - 2] = " ";
          $estadiosInexistentes = "No existen los siguientes estadíos en el programa: ".$estadiosInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $estadiosInexistentes;
        }

        // Recursos erroneos
        if ($tiposRecursoErroneos) {
          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= "Hay tipos de recurso incorrectos. Deben ser 'A', 'S' o 'P'.";
        }

        // Números incorrectos
        if ($numerosIncorrectos) {
          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= "Hay cantidades incorrectas. El valor debe ser mayor a 0 y los decimales separados por punto '.'.";
        }

        // Periodicidades incorrecta
        if ($periodicidadIncorrecta) {
          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= "Hay periodicidades incorrectas. El valor debe ser 1, 2, 3, 6 o 12 meses";
        }

         // Errores de centros de costo
         if ($centrosCostoInexistentes !== "") {
          $centrosCostoInexistentes[strlen($centrosCostoInexistentes) - 1] = " ";
          $centrosCostoInexistentes[strlen($centrosCostoInexistentes) - 2] = " ";
          $centrosCostoInexistentes = "No existen los siguientes centros de costo: ".$centrosCostoInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $centrosCostoInexistentes;
        }

        if ($centrosCostoIncorrectos !== "") {
          $centrosCostoIncorrectos[strlen($centrosCostoIncorrectos) - 1] = " ";
          $centrosCostoIncorrectos[strlen($centrosCostoIncorrectos) - 2] = " ";
          $centrosCostoIncorrectos = "No hay correspondencia de la sede en estos centros de costo: ".$centrosCostoIncorrectos;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $centrosCostoIncorrectos;
        }

        // Errores de actividades
        if ($actividadesInexistentes !== "") {
          $actividadesInexistentes[strlen($actividadesInexistentes) - 1] = " ";
          $actividadesInexistentes[strlen($actividadesInexistentes) - 2] = " ";
          $actividadesInexistentes = "No existen las siguientes actividades: ".$actividadesInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $actividadesInexistentes;
        }

        // Errores de actividades-cco
        if ($actividadesCcoInexistentes !== "") {
          $actividadesCcoInexistentes[strlen($actividadesCcoInexistentes) - 1] = " ";
          $actividadesCcoInexistentes[strlen($actividadesCcoInexistentes) - 2] = " ";
          $actividadesCcoInexistentes = "No existen las siguientes relaciones actividad - centro de costo: ".$actividadesCcoInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $actividadesCcoInexistentes;
        }

        // Errores de suministros
        if ($suministrosInexistentes !== "") {
          $suministrosInexistentes[strlen($suministrosInexistentes) - 1] = " ";
          $suministrosInexistentes[strlen($suministrosInexistentes) - 2] = " ";
          $suministrosInexistentes = "No existen los siguientes suministros: ".$suministrosInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $suministrosInexistentes;
        }

        // Errores de paquetes
        if ($paquetesInexistentes !== "") {
          $paquetesInexistentes[strlen($paquetesInexistentes) - 1] = " ";
          $paquetesInexistentes[strlen($paquetesInexistentes) - 2] = " ";
          $paquetesInexistentes = "No existen los siguientes paquetes: ".$paquetesInexistentes;

          if ($resultados->errores !== "") {
            $resultados->errores .= "-  ";
          }

          $resultados->errores .= $paquetesInexistentes;
        }

        if (!$camposVacios && $programasInexistentes == "" && $sedesInexistentes == "" && $estadiosInexistentes == "" &&
          $tiposRecursoErroneos == "" && $centrosCostoInexistentes == "" && $actividadesInexistentes == "" &&
          $actividadesCcoInexistentes == "" && $suministrosInexistentes == "" && $paquetesInexistentes == "" &&
          !$periodicidadIncorrecta && !$numerosIncorrectos && $centrosCostoIncorrectos == "") {
          $resultados->correcto = true;
        } else {
          $resultados->correcto = false;
        }

        $resultados->registros = $registrosProcesados;
      }
    });

    return json_encode($resultados);
  }

}
